<?php
//Niniejsza klasa Courier zawiera metody i własności z przykładów przedstawionych w rozdziale 1;
//niektóre metody i własności zostały ukryte w komentarzach, aby nie powodować błędów wielokrotnej deklaracji.
//Komentuj i odkomentowuj te elementy, których potrzebujesz!
class Courier
{
  public $name;
  public $home_country;
  
  
  //Pierwszy konstruktor: pamiętaj, że możesz używać tylko jednego konstruktora (dlatego pozostaw ten albo następny w komentarzu, zależnie którego potrzebujesz),
  //i że najlepiej jest go zadeklarować przed pozostałymi metodami klasy
  /*public function __construct($name) {
    $this->name = $name;
    return true;
  }*/
  
  //Drugi konstruktor
  public function __construct($name, $home_country) {
    $this->name = $name;
    $this->home_country = $home_country;
    return true;
  }
  
  //Trzeci konstruktor
  /*public function __construct($name, $home_country) {
    $this->name = $name;
    $this->home_country = $home_country;
    $this->logfile = $this->getLogFile();
    return true;
  }*/
  
  protected function getLogFile() {
    // Dziennik błędów mógłby znajdować się w pliku konfiguracyjnym
    return fopen('/tmp/error_log.txt', 'a');
  }

  public function log($message) {
    if($this->logfile) {
      fputs($this->logfile, 'Komunikat: ' . $message . "\n");
    }
  }

  public function __sleep() {
    // Zapisuj tylko „bezpieczne” własności
    return array("name", "home_country");
  }

  public function __wakeup() {
    // Własności są przywrócone, teraz dodaj plik dziennika
    $this->logfile = $this->getLogFile();
    return true;
  }
  
  public function __toString() {
    return $this->name . ' (' . $this->home_country . ')';
  }
  
  //Przestrzenie nazw i metody statyczne
  public static function getCouriersByCountry($country) {
    // Pobierz listę kurierów z home_country = $country

    // Utwórz obiekt klasy Courier dla każdego wyniku

    //Zwróć tablicę wyników
    return $courier_list;
  }

  public function ship($parcel) {
    // Wysyła paczkę do adresata
    return true;
  }

  /*public function calculateShipping($parcel) {
    // Sprawdza stawkę dla wybranego adresu (wymyślimy coś)
    $rate = 1.78;

    // Oblicza koszt
    $cost = $rate * $parcel->weight;
    return $cost;
  }*/
  
  public function calculateShipping(Parcel $parcel) {
    // Sprawdza stawkę za wysyłkę w dane miejsce
    $rate = $this->getShippingRateForCountry($parcel->destinationCountry);
    // Oblicza koszt
    $cost = $rate * $parcel->weight;
    return $cost;
  }

  private function getShippingRateForCountry($country) {
    // Tu powinien znajdować się algorytm obliczający stawkę
    // Dla przykładu po prostu wymyślimy jakąś liczbę
    return 1.2;
  }
  
  //Pierwszy rodzaj metod sprawdzających i ustawiających i chroniona własność $name
  /*protected $name;

  function getName() {
    return $this->name;
  }

  function setName($value) {
    $this->name = $value;
    return true;
  }*/
  
  //Magiczne metody __get() and __set()
  protected $data = array();

  public function __get($property) {
    return $this->data[$property];
  }

  public function __set($property, $value) {
    $this->data[$property] = $value;
    return true;
  }
  
  
  public function __call($name, $params) {
    if($name == 'sendParcel') {
      // Wymóg starego systemu, przekazanie do nowszej funkcji send()
      return $this->send($params[0]);
    } else {
      error_log('Nieudane wywołanie ' . $name . ' w klasie Courier');
      return false;
    }
  }
} //Koniec klasy Courier


// Klasa Courier z interfejsem Countable
/*class Courier implements Countable
{
  protected $count = 0;

  public function ship(Parcel $parcel) {
    $this->count++;
    // Wysłanie paczki
    return true;
  }

  public function count() {
    return $this->count;
  }
}*/
?>